﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Xml;

public partial class Admin_LunTan_BanKuai_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    protected new int ID;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改版块", "网站后台", "修改版块", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        ID = Convert.ToInt32(Request.QueryString["ID"]);
        if (this.IsPostBack)
            修改版块();
        else
            初始化();
    }

    private void 初始化()
    {
        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Club/" + 程序.设置["默认社区模板"] + "/Club/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            bool 是否WAP = true;
            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());

            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));

            读取.Close();

            switch (模板类型)
            {
                case "贴子列表":
                    if (是否WAP)
                    {
                        MoBan_TieZhiLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_TieZhiLieBiao.SelectedValue == "0")
                            MoBan_TieZhiLieBiao.SelectedValue = ID.ToString();
                    }
                    else
                    {
                        MoBan_3GTieZhiLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_3GTieZhiLieBiao.SelectedValue == "0")
                            MoBan_3GTieZhiLieBiao.SelectedValue = ID.ToString();
                    }
                    break;
                case "贴子内容":
                    if (是否WAP)
                    {
                        MoBan_TieZhiNeiRong.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_TieZhiNeiRong.SelectedValue == "0")
                            MoBan_TieZhiNeiRong.SelectedValue = ID.ToString();
                    }
                    else
                    {
                        MoBan_3GTieZhiNeiRong.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_3GTieZhiNeiRong.SelectedValue == "0")
                            MoBan_3GTieZhiNeiRong.SelectedValue = ID.ToString();
                    }
                    break;
                case "回贴列表":
                    if (是否WAP)
                    {
                        MoBan_HuiTieLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_HuiTieLieBiao.SelectedValue == "0")
                            MoBan_HuiTieLieBiao.SelectedValue = ID.ToString();
                    }
                    else
                    {
                        MoBan_3GHuiTieLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                        if (MoBan_3GHuiTieLieBiao.SelectedValue == "0")
                            MoBan_3GHuiTieLieBiao.SelectedValue = ID.ToString();
                    }
                    break;
            }
        }
        Hashtable 版块 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "社区_论坛_版块] WHERE [ID]=" + this.ID, 访问.连接));

        if (版块 == null)
            throw new Exception("版块不存在");

        BanKuaiMingChen.Text = Convert.ToString(版块["版块名称"]);
        WaiBuLianJieDiZhi.Text = Convert.ToString(版块["外部链接地址"]);
        BanKuaiJianJie.Text = Convert.ToString(版块["版块简介"]);
        if (Convert.ToBoolean(版块["版块状态"]))
            BanKuaiZhuangTai_T.Checked = true;
        else
            BanKuaiZhuangTai_F.Checked = true;
        JinZhiFangWenTiShi.Text = Convert.ToString(版块["禁止访问提示"]);
        MoBan_TieZhiLieBiao.SelectedValue = Convert.ToString(版块["模板_贴子列表"]);
        MoBan_3GTieZhiLieBiao.SelectedValue = Convert.ToString(版块["模板_3G贴子列表"]);
        MoBan_TieZhiNeiRong.SelectedValue = Convert.ToString(版块["模板_贴子内容"]);
        MoBan_3GTieZhiNeiRong.SelectedValue = Convert.ToString(版块["模板_3G贴子内容"]);
        MoBan_HuiTieLieBiao.SelectedValue = Convert.ToString(版块["模板_回贴列表"]);
        MoBan_3GHuiTieLieBiao.SelectedValue = Convert.ToString(版块["模板_3G回贴列表"]);
        FangWenQuanXian.SelectedIndex = Convert.ToInt32(版块["访问权限"]);
        FaTieQuanXian.SelectedIndex = Convert.ToInt32(版块["发贴权限"]);
        HuiTieQuanXian.SelectedIndex = Convert.ToInt32(版块["回贴权限"]);
        PaiXu.Text = Convert.ToString(版块["排序"]);
        if (Convert.ToBoolean(版块["显示状态"]))
            XianShiZhuangTai_T.Checked = true;
        else
            XianShiZhuangTai_F.Checked = true;
    }

    private void 修改版块()
    {
        访问.验证权限("30");
        String 版块名称 = BanKuaiMingChen.Text;
        String 外部链接地址 = WaiBuLianJieDiZhi.Text;
        String 版块简介 = BanKuaiJianJie.Text;
        bool 版块状态 = BanKuaiZhuangTai_T.Checked;
        String 禁止访问提示 = JinZhiFangWenTiShi.Text;
        int 模板_贴子列表 = Convert.ToInt32(MoBan_TieZhiLieBiao.SelectedValue);
        int 模板_3G贴子列表 = Convert.ToInt32(MoBan_3GTieZhiLieBiao.SelectedValue);
        int 模板_贴子内容 = Convert.ToInt32(MoBan_TieZhiNeiRong.SelectedValue);
        int 模板_3G贴子内容 = Convert.ToInt32(MoBan_3GTieZhiNeiRong.SelectedValue);
        int 模板_回贴列表 = Convert.ToInt32(MoBan_HuiTieLieBiao.SelectedValue);
        int 模板_3G回贴列表 = Convert.ToInt32(MoBan_3GHuiTieLieBiao.SelectedValue);
        int 访问权限 = FangWenQuanXian.SelectedIndex;
        int 发贴权限 = FaTieQuanXian.SelectedIndex;
        int 回贴权限 = HuiTieQuanXian.SelectedIndex;
        int 排序 = Convert.ToInt32(PaiXu.Text);
        bool 显示状态 = XianShiZhuangTai_T.Checked;

        if (版块名称.Length < 1 || 版块名称.Length > 50)
            throw new Exception("版块名称的长度必须在1-50之间");
        if (版块简介.Length < 0 || 版块简介.Length > 4000)
            throw new Exception("版块简介的长度必须在0-4000之间");

        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "社区_论坛_版块] SET " +
            "[版块名称]=@版块名称," +
            "[外部链接地址]=@外部链接地址,"+
            "[版块简介]=@版块简介," +
            "[版块状态]=@版块状态," +
            "[禁止访问提示]=@禁止访问提示," +
            "[模板_贴子列表]=@模板_贴子列表,"+
            "[模板_3G贴子列表]=@模板_3G贴子列表,"+
            "[模板_贴子内容]=@模板_贴子内容,"+
            "[模板_3G贴子内容]=@模板_3G贴子内容,"+
            "[模板_回贴列表]=@模板_回贴列表,"+
            "[模板_3G回贴列表]=@模板_3G回贴列表,"+
            "[访问权限]=@访问权限," +
            "[发贴权限]=@访问权限," +
            "[回贴权限]=@回贴权限," +
            "[排序]=@排序," +
            "[显示状态]=@显示状态 WHERE [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@版块名称", SqlDbType.NVarChar).Value = 版块名称;
        语句.Parameters.Add("@外部链接地址", SqlDbType.NVarChar).Value = 外部链接地址;
        语句.Parameters.Add("@版块简介", SqlDbType.NVarChar).Value = 版块简介;
        语句.Parameters.Add("@版块状态", SqlDbType.Bit).Value = 版块状态;
        语句.Parameters.Add("@禁止访问提示", SqlDbType.NVarChar).Value = 禁止访问提示;
        语句.Parameters.Add("@模板_贴子列表", SqlDbType.Int).Value = 模板_贴子列表;
        语句.Parameters.Add("@模板_3G贴子列表", SqlDbType.Int).Value = 模板_3G贴子列表;
        语句.Parameters.Add("@模板_贴子内容", SqlDbType.Int).Value = 模板_贴子内容;
        语句.Parameters.Add("@模板_3G贴子内容", SqlDbType.Int).Value = 模板_3G贴子内容;
        语句.Parameters.Add("@模板_回贴列表", SqlDbType.Int).Value = 模板_回贴列表;
        语句.Parameters.Add("@模板_3G回贴列表", SqlDbType.Int).Value = 模板_3G回贴列表;
        语句.Parameters.Add("@访问权限", SqlDbType.Int).Value = 访问权限;
        语句.Parameters.Add("@发贴权限", SqlDbType.Int).Value = 发贴权限;
        语句.Parameters.Add("@回贴权限", SqlDbType.Int).Value = 回贴权限;
        语句.Parameters.Add("@排序", SqlDbType.Int).Value = 排序;
        语句.Parameters.Add("@显示状态", SqlDbType.Bit).Value = 显示状态;
        语句.ExecuteNonQuery();

        更新缓存数据 更新缓存数据 = new 更新缓存数据(this.Context, 访问.连接);
        更新缓存数据.论坛版块_更新();

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改版块", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }
}
